/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import jclass.beans.GroupPanel;
import jclass.table3.EditStateWrapper;
import jclass.table3.JCCellRange;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SeriesEditor;
import jclass.table3.bean.EditStateCellRenderer;

public class EditStateEditor
extends SeriesEditor
implements ItemListener {
    private Checkbox checkTraversable;
    private Checkbox checkEditable;
    static final int NO = 0;
    static final int YES_NO = 1;
    static final int YES_YES = 2;

    public EditStateEditor() {
        super(1);
    }

    public void setValue(Object object) {
        if (object == null) {
            object = new EditStateWrapper("(all all traversable)", "(all all editable)");
        }
        this.tableView.setEditState((EditStateWrapper)object);
        super.setValue(object);
    }

    public Object getValue() {
        return this.tableView.getEditState();
    }

    public String getAsText() {
        return this.getStringValue(this.nl);
    }

    public String getJavaInitializationString() {
        String string = this.getStringValue(",\n      ");
        return "new jclass.table3.EditStateWrapper(" + string + ")";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object.equals(this.checkTraversable) || object.equals(this.checkEditable)) {
            JCCellRange jCCellRange = this.getSelectedRange();
            if (jCCellRange == null) {
                return;
            }
            boolean bl = this.checkTraversable.getState();
            this.tableView.setTraversable(jCCellRange, bl);
            if (!bl) {
                this.checkEditable.setState(false);
            }
            this.checkEditable.setEnabled(bl);
            this.tableView.setEditable(jCCellRange, this.checkEditable.getState());
            this.updatePropertyPanel(null);
        }
    }

    protected void init() {
        super.init();
        this.tableView.setEditable(-997, -997, true);
        this.tableView.getDataView().setEditorsTable(new Hashtable());
        this.updatePropertyPanel(new JCCellRange(0, 0, 0, 0));
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.support.firePropertyChange("editState", null, this.getValue());
        if (jCCellRange == null) {
            return;
        }
        boolean bl = this.tableView.getTraversable(jCCellRange.start_row, jCCellRange.start_column);
        boolean bl2 = bl ? this.tableView.getEditable(jCCellRange.start_row, jCCellRange.start_column) : false;
        this.checkTraversable.setState(bl);
        this.checkEditable.setState(bl2);
        this.checkEditable.setEnabled(bl);
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new EditStateCellRenderer(this);
    }

    protected Component makePropertyPanel() {
        this.checkTraversable = new Checkbox("Traversable");
        this.checkEditable = new Checkbox("Editable");
        GroupPanel groupPanel = new GroupPanel("Edit state");
        groupPanel.setLayout(new FlowLayout(0, 10, 6));
        groupPanel.add(this.checkTraversable);
        groupPanel.add(this.checkEditable);
        this.checkTraversable.addItemListener(this);
        this.checkEditable.addItemListener(this);
        return groupPanel;
    }

    private String getStringValue(String string) {
        String[] stringArray = new String[]{this.tableView.fromSeries(16), this.tableView.fromSeries(8)};
        String string2 = "\"" + stringArray[0] + "\"" + string + "\"" + stringArray[1] + "\"";
        return string2;
    }
}

